# Databases & RecyclerView

Bu bölümde ilk olarak Room kütüphanesini kullanarak bir veritabanı oluşturmayı ve asenkron programlamayı basitleştirmek için coroutineleri kullanmayı öğreneceksiniz. 
İkinci kısımda ise, RecyclerView ile öğelerin bir listesini görüntüleme ve liste öğelerini tıklanabilir hale getirme üzerine çalışacaksınız. 
Bölüm süresince, kullanıcıların uyku kalitelerini derecelendirmelerine ve uyku verilerini zaman içinde depolamalarına olanak 
tanıyan **TrackMySleep** uygulamasını tamamlayacaksınız.

## İşte Konu başlıkları:

- [Bir Room Database Oluşturun](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%201%20-%20Bir%20Room%20Database%20Olu%C5%9Fturun)
  - Başlangıç uygulamasını indirin & inceleyin
  - SleepNight entity'sini oluşturun
  - DAO'yu oluşturun
  - Bir Room database oluşturun & test edin

- [Room ile Coroutineleri Kullanın](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%202%20-%20Room%20ile%20Coroutineleri%20Kullan%C4%B1n)
  - Başlangıç kodunu inceleyin
  - ViewModel ekleyin
  - Coroutineler
  - Data toplayın & görüntüleyin
  
- [Button Statelerini(Durumlarını) Kontrol Etmek İçin LiveData Kullanın](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%203%20-%20Button%20Statelerini%20Kontrol%20Etmek%20%C4%B0%C3%A7in%20LiveData%20Kullan%C4%B1n%20)
  - Navigation ekleyin
  - Uyku kalitesini kaydedin
  - Button görünürlüğünü kontrol edin & bir Snackbar ekleyin
 
- [RecyclerView Temelleri](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%204%20-%20RecyclerView%20Temelleri)
  - RecyclerView
  - RecyclerView ve bir Adapter uygulayın
  - Tüm uyku datası için bir ViewHolder oluşturun
  - Kodunuzu geliştirin
  
- [RecyclerView ile DiffUtil & Data Binding](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%205%20-%20RecyclerView%20ile%20DiffUtil%20%26%20Data%20Binding)
  - Şimdiye kadar neler yaptığınızı gözden geçirin & başlayın
  - DiffUtil ile listenin içeriğini yenileyin
  - Listenizi yönetmek için ListAdapter kullanın
  - RecyclerView ile DataBinding kullanın
  - Binding adapterlar yaratın

- [RecyclerView'da Grid Layout](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%206%20-%20RecyclerView'da%20Grid%20Layout%20)
  - Layoutlar & LayoutManagerlar
  - GridLayout uygulayın

- [RecyclerView Öğeleri ile Etkileşime Geçin](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%207%20-%20RecyclerView%20%C3%96%C4%9Feleri%20ile%20Etkile%C5%9Fime%20Ge%C3%A7in
  - Başlangıç kodunu alın & uygulamadaki değişiklikleri inceleyin
  - Öğeleri tıklanabilir yapın
  - Öğe tıklamalarını yönetin

- [RecyclerView'da Headerlar (Başlıklar) ekleyin](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Dok%C3%BCman%208%20-%20RecyclerView'da%20Headerlar%20ekleyin) 
  - RecyclerView'da Headerlar
  - RecyclerView'unuza bir header ekleyin
  - Liste manipülasyonları için coroutineleri kullanın
  - Header'ı ekrana yayılacak şekilde uzatın
  
- [Quiz](https://github.com/serkanalc/Android-Kotlin-Fundamentals/tree/main/Part%2007%20-%20Databases%20%26%20RecyclerView/Quiz)

## Ödül:

Eğer bu yazıyı okuduysanız artık hızlı bir quizle çalışmanızı ödüllendirebilirsiniz. [Bu linkten](https://developer.android.com/courses/quizzes/kotlin-fundamentals-seven/kotlin-fundamentals-seven?continue=https%3A%2F%2Fdeveloper.android.com%2Fcourses%2Fpathways%2Fkotlin-fundamentals-seven%23quiz-%2Fcourses%2Fquizzes%2Fkotlin-fundamentals-seven%2Fkotlin-fundamentals-seven) 
ilerleyişinizi takip edebilir, kendinizi test edebilir ve Google Developers Profile ve diğer sosyal medyalarda paylaşılabilir
bir badge kazanabilirsiniz!

![fun_7](https://user-images.githubusercontent.com/46448616/140919004-076f0dc0-e88b-41a3-b968-2eb51274f26c.png)
